
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_IO_PAK_H_
#define _NEUROSIS_ENGINE_IO_PAK_H_

/***************************************************************************/

//------------------------------------------------
#define CYPHER_VALUE							23
//------------------------------------------------

/***************************************************************************/

class CNeurosisPakFile
{
	public:
		CNeurosisPakFile();
		//! Constructor/Deconstructor
		~CNeurosisPakFile();

		//! Clear current data
		bool	Clear();
		//! Create file - if checkModifiedDate is true, the outputFile is only created if none is found or it's older than the files in the inputFolder
		bool	Create(char *inputFolder, char *outputFile, bool checkModifiedDate = false);
		//! Load PAK header and file table
		bool	Load(char *filename);
		//! Extract every file from PAK
		bool	Extract();
		//! Extract only one file from PAK
		bool	Extract_File(char *filename);

	private:
		struct SPakHeader {
			char		mSignature[8];													// Signature (LP23.COM)
			float		mVersion;																// Version number (1.0)
			DWORD		mFileEntries;														// Number of file table entries
			char		mID[10];																// ID (Random)
		};

		struct SFileTableEntry {
			char						mFilename[30];									// Name of one file in the PAK
			DWORD						mFileSize;											// The size of the file in bytes
			DWORD						mFileOffset;										// Offset of file in the PAK
			SFileTableEntry	*pNext;													// Next file table entry (is a linked list)
		};

		bool	Generate();																	// Create header and file table
		bool	WorkOutOffsets();														// Work out the file offsets in the PAK

		SFileTableEntry *pFileTable;											// The master file table for the PAK
		CString					mFolderPath;											// Location of folder to compile
		CString					mPakName;													// Location to save PAK
		SPakHeader			mHeader;													// The header of the PAK file
};

/***************************************************************************/
#endif